module ActionMailer
  module Ja
    # NEC 特殊文字と IBM 拡張文字の一部を代替文字に置換して表示します。
    # http://ja.wikipedia.org/wiki/Microsoft%E3%82%B3%E3%83%BC%E3%83%89%E3%83%9A%E3%83%BC%E3%82%B8932
    REPLACE_CHAR_MAP = {
      "①" => "(1)", 
      "②" => "(2)", 
      "③" => "(3)", 
      "④" => "(4)", 
      "⑤" => "(5)", 
      "⑥" => "(6)", 
      "⑦" => "(7)", 
      "⑧" => "(8)", 
      "⑨" => "(9)", 
      "⑩" => "(10)", 
      "⑪" => "(11)", 
      "⑫" => "(12)", 
      "⑬" => "(13)", 
      "⑭" => "(14)", 
      "⑮" => "(15)", 
      "⑯" => "(16)", 
      "⑰" => "(17)", 
      "⑱" => "(18)", 
      "⑲" => "(19)", 
      "⑳" => "(20)", 
      "Ⅰ" => "I", 
      "Ⅱ" => "II", 
      "Ⅲ" => "III", 
      "Ⅳ" => "IV", 
      "Ⅴ" => "V", 
      "Ⅵ" => "VI", 
      "Ⅶ" => "VII", 
      "Ⅷ" => "VIII", 
      "Ⅸ" => "IX", 
      "Ⅹ" => "X", 
      "㍉" => "ミリ", 
      "㌔" => "キロ", 
      "㌢" => "センチ", 
      "㍍" => "メートル", 
      "㌘" => "グラム", 
      "㌧" => "トン", 
      "㌃" => "アール", 
      "㌶" => "ヘクタール", 
      "㍑" => "リットル", 
      "㍗" => "ワット", 
      "㌍" => "カロリー", 
      "㌦" => "ドル", 
      "㌣" => "セント", 
      "㌫" => "パーセント", 
      "㍊" => "ミリバール", 
      "㌻" => "ページ", 
      "㎜" => "mm", 
      "㎝" => "cm", 
      "㎞" => "km", 
      "㎎" => "mg", 
      "㎏" => "kg", 
      "㏄" => "cc", 
      "㎡" => "m^2", 
      "㍻" => "平成", 
      "〝" => "\"", 
      "〟" => "\"", 
      "№" => "No.", 
      "㏍" => "K.K.", 
      "℡" => "TEL", 
      "㊤" => "（上）", 
      "㊥" => "（中）", 
      "㊦" => "（下）", 
      "㊧" => "（左）", 
      "㊨" => "（右）", 
      "㈱" => "（株）", 
      "㈲" => "（有）", 
      "㈹" => "（代）", 
      "㍾" => "明治", 
      "㍽" => "大正", 
      "㍼" => "昭和", 
      "ⅰ" => "i", 
      "ⅱ" => "ii", 
      "ⅲ" => "iii", 
      "ⅳ" => "iv", 
      "ⅴ" => "v", 
      "ⅵ" => "vi", 
      "ⅶ" => "vii", 
      "ⅷ" => "viii", 
      "ⅸ" => "ix", 
      "ⅹ" => "x", 
      "￤" => "|", 
      "＇" => "'", 
      "＂" => "\"",
    }.freeze
  end
end
